import pandas as pd
import pickle
from decision_company import read_csv_file, bind_dataframe, aggregate_grouped_data

atp_tennis = read_csv_file('atp_tennis.csv')

# Group the DataFrame by player and compute the average rank and win/loss ratio for each unique player
grouped_player_data = bind_dataframe(player_data, 'Player')
agg_dict = {'Rank': 'mean', 'Win_Loss_Ratio': 'mean', 'Surface': 'count'}
unique_player_data = aggregate_grouped_data(grouped_player_data, agg_dict)
unique_player_data.columns = ['Player', 'Avg_Rank', 'Avg_Win_Loss_Ratio', 'Match_Count']

print(unique_player_data)
pickle.dump(unique_player_data,open("./ref_result/unique_player_data.pkl","wb"))